#include <iostream>
#include <cmath>
using namespace std;

const int MAXN = 1000000;   // stavi pravo ogranicenje iz zadatka

long long xcoord[MAXN + 2];
long long hcoord[MAXN + 2];

int main() {
    int n;
    cin >> n;

    // fiktivne tacke pramac i krma
    xcoord[0] = 0;
    hcoord[0] = 0;
    xcoord[n + 1] = 1000000000LL;
    hcoord[n + 1] = 0;

    for (int i = 1; i <= n; i++) cin >> xcoord[i];
    for (int i = 1; i <= n; i++) cin >> hcoord[i];

    for (int i = 1; i <= n; i++) {
        long long najbolja = -1;

        // 1) drugi jarboli
        for (int j = 1; j <= n; j++) {
            if (j == i) continue;
            if (hcoord[j] >= hcoord[i]) {
                long long d = llabs(xcoord[j] - xcoord[i]);
                if (najbolja == -1 || d < najbolja) najbolja = d;
            }
        }

        // 2) segmenti kanala
        for (int k = 0; k <= n; k++) {
            long long x1 = xcoord[k],   y1 = hcoord[k];
            long long x2 = xcoord[k+1], y2 = hcoord[k+1];

            if (x1 == x2) continue;

            if (y1 < hcoord[i] && y2 < hcoord[i]) continue;

            if (y1 >= hcoord[i] && y2 >= hcoord[i]) {
                long long d1 = llabs(x1 - xcoord[i]);
                long long d2 = llabs(x2 - xcoord[i]);
                long long d = (d1 < d2 ? d1 : d2);
                if (najbolja == -1 || d < najbolja) najbolja = d;
                continue;
            }

            double dx = (double)(x2 - x1);
            double dy = (double)(y2 - y1);
            double need = (double)hcoord[i];

            double X = x1 + (need - (double)y1) * dx / dy;
            double distD = fabs(X - (double)xcoord[i]);
            long long d = (long long)distD;   // bez +0.5

            if (najbolja == -1 || d < najbolja) najbolja = d;
        }

        cout << najbolja << '\n';
    }

    return 0;
}